/**
 * This class saves information about which target state is simulated by which composition state
 */
package gui.menus.file.export;

import gui.GenericLoader;
import gui.MainFrame;
import gui.XML.saveToXML;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
/**
 * @author Andrea
 *
 */
public class SaveSimulatorsItem extends javax.swing.JMenuItem
{
	static final long serialVersionUID = 1l;
	final JFileChooser fc;
	
	public SaveSimulatorsItem()
	{
		super();
		String[] extensions = {"xml"};
		FileNameExtensionFilter filter = new FileNameExtensionFilter(".xml",extensions);
		fc =new JFileChooser();
		fc.setFileFilter(filter);
		init();
	}
	
	void init()
	{
		this.setText("Simulation Informations as xml...");
		this.setToolTipText("Saves information about which Composition State simulates a particular Target System State");
		
		this.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				/**
				 * this part is responsible for saving the file.
				 */
				fc.setSelectedFile(new File("simulation"));
				int action = fc.showSaveDialog(MainFrame.getInstance());
				if(action == JFileChooser.APPROVE_OPTION)
				{
					String fileName = fc.getSelectedFile().getPath();
					File toSave = new File(fc.getSelectedFile().getPath()+".xml");
					boolean writeFile = true;
					boolean wantsStylesheet = false;
					/**
					 * in the following: if file already exists, then appears a prompt asking
					 * if you want to replace it. If so, the program continues,
					 * otherwise writeFile will became FALSE and the program terminates without doing anything.
					 */
					if(toSave.exists())
					{
						if(JOptionPane.showConfirmDialog(null, "A file with the specified name already exists.\nDo you want to replace it?", "Specified file already exists", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE)!=JOptionPane.YES_OPTION)
						{
							writeFile = false;
						}
						else
						{
							toSave.delete();
						}
					}
					try
					{
						if(writeFile)
						{
							/**
							 * in the following: you decide if export also the style-sheet for 
							 * for the XML file.
							 */
							if(JOptionPane.showConfirmDialog(null, "Would you like to export the default stylesheet\nfor this file?", "Question", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE)==JOptionPane.YES_OPTION)
							{
								wantsStylesheet = true;
							}
							
							/**
							 * here the file will be saved
							 */
							
							saveToXML.saveSimulationXML(GenericLoader.getSimulationDataToExport(), fileName, wantsStylesheet);
							
							JOptionPane.showMessageDialog(MainFrame.getInstance(), "File saved correctly", "Message", JOptionPane.INFORMATION_MESSAGE);
						}
					}
					catch(IOException ex)
					{
						JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
					}
					catch(Exception exc)
					{
						JOptionPane.showMessageDialog(null, exc.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
					}
					
				}
			}
		});
	}
}
